/*
 * Decompiled with CFR 0.152.
 */
package com.github.charlyb01.music_control.categories;

import com.github.charlyb01.music_control.categories.MusicIdentifier;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import net.minecraft.class_1144;
import net.minecraft.class_2477;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import org.jetbrains.annotations.NotNull;

public class Music
implements Comparable<Music> {
    public static final String ALL_MUSICS = "all";
    public static final String ALL_MUSIC_DISCS = "disc";
    public static final String DEFAULT_MUSICS = "default";
    public static final class_2960 EMPTY_MUSIC_ID = class_1144.field_5592.method_4767();
    public static final String EMPTY_MUSIC = EMPTY_MUSIC_ID.toString();
    public static final HashMap<String, HashSet<Music>> MUSIC_BY_NAMESPACE = new HashMap();
    public static final HashSet<class_2960> EVENTS = new HashSet();
    public static final HashSet<class_2960> BLACK_LISTED_EVENTS = new HashSet<class_2960>(List.of(class_2960.method_60656((String)"music.overworld.old_growth_taiga")));
    public static final HashMap<class_2960, HashSet<Music>> MUSIC_BY_EVENT = new HashMap();
    public static final HashMap<class_2960, HashSet<class_2960>> EVENTS_OF_EVENT = new HashMap();
    public static final Comparator<class_2960> TRANSLATED_ORDER = (a, b) -> String.CASE_INSENSITIVE_ORDER.compare(Music.getTranslatedText(a).getString(), Music.getTranslatedText(b).getString());
    private static final HashMap<class_2960, class_2561> TRANSLATION_CACHE = new HashMap();
    private static class_2477 LAST_LANG_INSTANCE = class_2477.method_10517();
    private final class_2960 identifier;
    private final HashSet<class_2960> events;

    public Music(class_2960 identifier) {
        this.identifier = identifier;
        this.events = new HashSet();
    }

    public static Music getMusicFromIdentifier(class_2960 identifier) {
        Optional<Music> music = MUSIC_BY_NAMESPACE.get(ALL_MUSICS).stream().filter(music1 -> music1.getIdentifier().equals((Object)identifier)).findAny();
        return music.orElse(null);
    }

    public class_2960 getIdentifier() {
        return this.identifier;
    }

    public HashSet<class_2960> getEvents() {
        return this.events;
    }

    public void addEvent(class_2960 event) {
        if (MUSIC_BY_EVENT.containsKey(event)) {
            MUSIC_BY_EVENT.get(event).add(this);
            this.events.add(event);
        }
    }

    public void removeEvent(class_2960 event) {
        if (MUSIC_BY_EVENT.containsKey(event)) {
            MUSIC_BY_EVENT.get(event).remove(this);
            this.events.remove(event);
        }
    }

    public boolean equals(Object obj) {
        return obj instanceof Music && this.identifier.equals((Object)((Music)obj).identifier);
    }

    @Override
    public int compareTo(@NotNull Music music) {
        return this.identifier.method_12833(music.identifier);
    }

    public static class_2561 getTranslatedText(class_2960 identifier) {
        if (LAST_LANG_INSTANCE != class_2477.method_10517()) {
            TRANSLATION_CACHE.clear();
            LAST_LANG_INSTANCE = class_2477.method_10517();
        }
        if (TRANSLATION_CACHE.containsKey(identifier)) {
            return TRANSLATION_CACHE.get(identifier);
        }
        String idString = identifier.toString();
        String path = identifier.method_12832();
        if (LAST_LANG_INSTANCE.method_4678(idString)) {
            TRANSLATION_CACHE.put(identifier, (class_2561)class_2561.method_43471((String)idString));
        } else if (MusicIdentifier.isBiome(identifier)) {
            TRANSLATION_CACHE.put(identifier, (class_2561)class_2561.method_43469((String)"music.format.biome", (Object[])new Object[]{class_2561.method_43471((String)("biome." + identifier.method_12836() + "." + path.split("\\.", 3)[2]))}));
        } else if (MusicIdentifier.isDimension(identifier)) {
            TRANSLATION_CACHE.put(identifier, (class_2561)class_2561.method_43469((String)"music.format.dimension", (Object[])new Object[]{class_2561.method_43471((String)path)}));
        } else if (MusicIdentifier.isDisc(identifier)) {
            TRANSLATION_CACHE.put(identifier, (class_2561)class_2561.method_43469((String)"music.format.disc", (Object[])new Object[]{class_2561.method_43471((String)path)}));
        } else if (MusicIdentifier.isMisc(identifier)) {
            TRANSLATION_CACHE.put(identifier, (class_2561)class_2561.method_43469((String)"music.format.misc", (Object[])new Object[]{class_2561.method_43471((String)path)}));
        }
        return TRANSLATION_CACHE.getOrDefault(identifier, (class_2561)class_2561.method_43471((String)idString));
    }
}

